<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-08-06 13:48
 */
interface BillsreturnDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billsreturn 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billsreturn primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billsreturn billsreturn
 	 */
	public function insert($billsreturn);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billsreturn billsreturn
 	 */
	public function update($billsreturn);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillid($value);

	public function queryByReturnedprice($value);

	public function queryByDate($value);

	public function queryByDeleted($value);


	public function deleteByBillid($value);

	public function deleteByReturnedprice($value);

	public function deleteByDate($value);

	public function deleteByDeleted($value);


}
?>